/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_decompose_endpoint_addr.c,v 1.35 2006/05/29 23:26:07 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx_byteswap.h"
#include "mx__lib_types.h"
#include "mx__partner.h"
#include "mx__endpoint.h"

MX_FUNC(mx_return_t)
mx_decompose_endpoint_addr(mx_endpoint_addr_t endpoint_addr,
			   uint64_t *nic_id,
			   uint32_t *endpoint_id)
{
  struct mx__partner *partner = mx__partner_from_addr(&endpoint_addr);
  *nic_id = partner->nic_id;
  *endpoint_id = partner->eid;
  return MX_SUCCESS;
}


#ifdef MX_VERSIONED_SYMS
mx_return_t
mx_decompose_endpoint_addr_v1(mx_endpoint_addr_t endpoint_addr,
			      uint64_t *nic_id,
			      uint32_t *endpoint_id,
			      uint32_t *filter_value)
{
  mx_decompose_endpoint_addr(endpoint_addr, nic_id, endpoint_id);
  *filter_value = Mx_endpoints->connect.key;
  return MX_SUCCESS;
}

__asm__(".symver mx_decompose_endpoint_addr_v1,mx_decompose_endpoint_addr@MX_0.0");

#endif

MX_FUNC(mx_return_t)
mx_set_endpoint_addr_context(mx_endpoint_addr_t endpoint_addr, void *context)
{
  struct mx__partner *partner = mx__partner_from_addr(&endpoint_addr);
  partner->context = context;
  return MX_SUCCESS;
}

MX_FUNC(mx_return_t)
mx_get_endpoint_addr_context(mx_endpoint_addr_t endpoint_addr, void **context)
{
  struct mx__partner *partner = mx__partner_from_addr(&endpoint_addr);
  *context = partner->context;
  return MX_SUCCESS;
}
